<?php

/* *
 * 莫言支付SDK服务类
 * 说明：
 * 包含发起支付、查询订单、回调验证等功能
 */

class Pay
{

    /**
     * 接口地址
     */
    private $apiUrl;

    /**
     * 商户PID
     */
    private $pid;

    /**
     * 商户秘钥
     */
    private $merchantPrivateKey;

    /**
     * 签名类型
     */
    private $signType = 'MD5';


    function __construct($config){
        $this->apiUrl = $config['api_url'];
        $this->pid = $config['pid'];
        $this->merchantPrivateKey = $config['merchant_private_key'];
    }

    /**
     * 页面跳转支付 - 跳转
     */
    public function pagePay($params, $button='正在跳转'){
        $requestUrl = $this->apiUrl.'/submit.php';
        $params = $this->_buildRequestParam($params);

        $html = '<form id="dopay" action="'.$requestUrl.'" method="post">';
        foreach ($params as $k=>$v) {
            $html.= '<input type="hidden" name="'.$k.'" value="'.$v.'"/>';
        }
        $html .= '<input type="submit" value="'.$button.'"></form><script>document.getElementById("dopay").submit();</script>';

        return $html;
    }

    /**
     * 页面跳转支付 - 获取跳转链接
     */
    public function getPayLink($params){
        $requestUrl = $this->apiUrl.'/submit.php';
        $param = $this->_buildRequestParam($params);

        return $requestUrl.'?'.http_build_query($param);
    }


    /**
     * API接口支付
     */
    public function apiPay($params){
        $params = $this->_buildRequestParam($params);
        $response = $this->_curlRequest($this->apiUrl.'/mapi.php', 'POST', $params);
        return json_decode($response, true);
    }


    /**
     * 构建请求参数
     */
    private function _buildRequestParam($params){
        $params['pid'] = $this->pid;
        $params['sign'] = $this->_makeSign($params);
        $params['sign_type'] = $this->signType;
        return $params;
    }

    /**
     * 生成签名
     */
    private function _makeSign($params){
        ksort($params);
        $signStr = '';
        foreach ($params as $k => $v) {
            if(is_array($v) || $this->_isEmpty($v) || $k == 'sign' || $k == 'sign_type') continue;
            $signStr .= $k . '=' . $v . '&';
        }
        $signStr = substr($signStr, 0, -1);
        $signStr .= $this->merchantPrivateKey;
        return md5($signStr);
    }

    /**
     * 判断值是否为空
     */
    private function _isEmpty($value)
    {
        return $value === null || trim($value) === '';
    }


    /**
     * cURL请求方法
     * @param string $url 请求地址
     * @param string $method 请求方法 GET|POST
     * @param array $data 请求参数
     * @param array $headers 请求头
     */
    private function _curlRequest($url, $method = 'GET', $data = [], $headers = []) {
        // 初始化cURL
        $ch = curl_init();

        // 设置基本选项
        curl_setopt_array($ch, [
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_SSL_VERIFYHOST => false,
        ]);

        // 设置请求方法
        $method = strtoupper($method);
        if ($method === 'POST') {
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
        } else {
            // GET请求将参数拼接到URL
            if (!empty($data)) {
                $query = http_build_query($data);
                if (strpos($url, '?') === false) {
                    curl_setopt($ch, CURLOPT_URL, $url . '?' . $query);
                } else {
                    curl_setopt($ch, CURLOPT_URL, $url . '&' . $query);
                }
            }
        }

        // 设置请求头
        if (!empty($headers)) {
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        }

        // 执行请求
        $response = curl_exec($ch);

        // 关闭cURL
        curl_close($ch);

        // 返回结果
        return $response;
    }
}